/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef _TSTUTILS_H_
#define _TSTUTILS_H_

#include "drmcommon.h"
#include "drmutilities.h"
#include "drmcontextsizes.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Non-MS compilers may not implement _snwprintf. However, it is identical to the ANSI swprintf.
   Unfortunately MS compilers before VC 2005 implement swprintf differently than the ANSI standard */
#if !defined (_MSC_VER)
#define _snwprintf swprintf
#endif

/* 
	malloc a DRM_STRING to hold the ansi string. Caller must call
	free((void*)pwszStr->pwszString) after use
*/
void DRM_API MakeDRMString(DRM_CONST_STRING *pwszStr, const char *szStr);

/*
	Convert szStr to wide string and then compare to pwszStr. Returns 0 if same.
*/
int DRM_API CompDRMString(DRM_CONST_STRING *pwszStr, const char *szStr);
int DRM_API CompWideString(const DRM_WCHAR *pwszStr, const char *szStr);

/*
	Loads the file content into a memory blob. Callers must free *ppBuffer after use.
*/
DRM_BOOL DRM_API LoadTestFile(const DRM_CHAR* pszFolder, const DRM_CHAR* pszPath, DRM_BYTE **ppBuffer, DRM_DWORD *pSize);
DRM_BOOL DRM_API LoadTestFileW(const DRM_WCHAR* pwszFolder, const DRM_WCHAR* pwszPath, DRM_BYTE **ppBuffer, DRM_DWORD *pSize);

/* Save a blob to a file */
DRM_BOOL DRM_API SaveToFileW(const DRM_WCHAR* pwszPath, DRM_BYTE *pbData, DRM_DWORD cbData);


DRM_BOOL DRM_API IsDigitalOnlyString(char *p);

/*	Allocates the hds context and opens the specific store. If fails, then *ppHds==NULL */
DRM_RESULT DRM_API OpenHDS(DRM_HDS_CONTEXT **ppHds, const DRM_WCHAR *pwszStorePath, DRM_BOOL fCreateNew);

/* Close the hds store and release the context. *pHds is invalid after the call succeeds. */
DRM_RESULT DRM_API CloseHDS(DRM_HDS_CONTEXT *pHds);

/*	wszXML is <XX><DATA>...</DATA><SIGNATURE>...</SIGNATURE></XX> 
	This function verify the <DATA> section using the public key.
*/
DRM_RESULT DRM_API VerifyXMLDataSigature(DRM_CONST_STRING *pwszXML, DRM_CONST_STRING *pwszPubKey);

#define FILETIME_TO_SECONDS 10000000L
DRM_RESULT DRM_API tChangeSystemTime(long loffset); /*roll forward if loffset is positive; backward if negative.*/

#ifdef WINCE_TEST

#define BASE_DIR    "\\windows\\drmtest"

/*run time*/
#if !defined( min )
    #define min( a, b) ( (a)<(b)?(a):(b))
#endif

void remove(char* filename);
DRM_DWORD MyClock();

#endif

#ifdef __cplusplus
}
#endif

#endif

